library(mgcv)
library(plyr)
library(ggplot2)
library(reshape2)
library(foreach)
library(doParallel)
library(tidyr)

### CHANGED !!!
# run with corrected and changed files (folder: .../Changed)

### RUN functions from files: 
# LPIMain.R
# ProcessFile.R
# CalcLPI.R
# calculate_index.R
# bootstrap_lpi.R
# debug_print.R
# plot_lpi.R
# ggplot_lpi.R
# ggplot_multi_lpi.R

# use_weightings = T -- taxa-specific lambdas are weighted by an estimated proportion of species richness of taxa
# use_weightings_B = T -- realm-specific lambdas are weighted by an estimated proportion of species richness of realms
# DATA_LENGTH_MIN = 2 -- time series with two and more data points are processed
# PLOT_MAX -- PLOT_MAX - REF_YEAR + 2 = the number of values of Index (PLOT_MAX = 2015 -- LPI until 2016)
# CAP_LAMBDAS = F -- lambda values outside the limits (LAMBDA_MIN, LAMBDA_MAX) are not replaced by limit values (LAMBDA_MIN, LAMBDA_MAX)

# added arguments:
# min_year and max_year -- population data are limited by the range <min_year, max_year>
# TS_length_min -- the minimum number of years between the first and last year of the population series
# reshuffle -- reshuffle time series within the study period (default = F)

# data: https://livingplanetindex.org/
# weights for taxa and realms: S10-S13 Table from McRae et al. 2017
# data for calculations converted into the format: columns (Binomial ID year popvalue), rows (populations), separately for each realm and taxon
# ..._infile.txt in the format: columns (FileName Group Weighting WeightingB)
# following objects saved in LPI_changed.RData



### global LPI and LPI of three ecosystems
# Global LPI
G_lpi <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_lpi <- G_lpi[complete.cases(G_lpi),] 
ggplot_lpi(G_lpi, ylims=c(0, 2)) # 0.326975

# Terrestrial LPI
T_lpi <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                  CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_lpi <- T_lpi[complete.cases(T_lpi),] 
ggplot_lpi(T_lpi, ylims=c(0, 2)) # 0.3678864

# Freshwater LPI
F_lpi <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_lpi <- F_lpi[complete.cases(F_lpi),] 
ggplot_lpi(F_lpi, ylims=c(0, 2)) # 0.1807631

# Marine LPI
M_lpi <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_lpi <- M_lpi[complete.cases(M_lpi),] 
ggplot_lpi(M_lpi, ylims=c(0, 2)) # 0.5256787 (2014)


### change in the number of records in the time series (fullness)
# LPI with at least 3 records in the population series (diff - difference between the adjusted LPI value and original)
G_3r <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_3r <- G_3r[complete.cases(G_3r),] 
ggplot_lpi(G_3r, ylims=c(0, 2)) # 0.4702302 (diff 14.3%)
lpis_comp <- list(G_lpi, G_3r)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 3 records"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# LPI with at least 5 records in the population series
G_5r <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_5r <- G_5r[complete.cases(G_5r),] 
ggplot_lpi(G_5r, ylims=c(0, 2)) # 0.474307 (diff 14.7%)
lpis_comp <- list(G_lpi, G_5r)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 5 records"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# LPI with at least 10 records in the population series
G_10r <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_10r <- G_10r[complete.cases(G_10r),] 
ggplot_lpi(G_10r, ylims=c(0, 2)) # 0.5912993 (diff 26.4%)
lpis_comp <- list(G_lpi, G_10r)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 10 records"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Terrestrial LPI with at least 3 records in the population series
T_3r <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_3r <- T_3r[complete.cases(T_3r),] 
ggplot_lpi(T_3r, ylims=c(0, 2)) # 0.3813287 (diff 1.3%)

# Freshwater LPI with at least 3 records in the population series
F_3r <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_3r <- F_3r[complete.cases(F_3r),] 
ggplot_lpi(F_3r, ylims=c(0, 2)) # 0.3736675 (diff 19.3%)

# Marine LPI with at least 3 records in the population series
M_3r <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_3r <- M_3r[complete.cases(M_3r),] 
ggplot_lpi(M_3r, ylims=c(0, 2)) # 0.7297041 (diff 20.4%)

# Terrestrial LPI with at least 5 records in the population series
T_5r <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_5r <- T_5r[complete.cases(T_5r),] 
ggplot_lpi(T_5r, ylims=c(0, 2)) # 0.4233201 (diff 5.5%)
lpis_comp <- list(T_lpi, T_5r)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 5 records"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Freshwater LPI with at least 5 records in the population series
F_5r <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_5r <- F_5r[complete.cases(F_5r),] 
ggplot_lpi(F_5r, ylims=c(0, 2)) # 0.3223075 (diff 14.2%)
lpis_comp <- list(F_lpi, F_5r)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 5 records"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Marine LPI with at least 5 records in the population series
M_5r <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_5r <- M_5r[complete.cases(M_5r),] 
ggplot_lpi(M_5r, ylims=c(0, 2)) # 0.7820585 (diff 25.6%)
lpis_comp <- list(M_lpi, M_5r)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 5 records"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Terrestrial LPI with at least 10 records in the population series
T_10r <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_10r <- T_10r[complete.cases(T_10r),] 
ggplot_lpi(T_10r, ylims=c(0, 2)) # 0.7728989 (diff 40.5%)

# Freshwater LPI with at least 10 records in the population series
F_10r <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_10r <- F_10r[complete.cases(F_10r),] 
ggplot_lpi(F_10r, ylims=c(0, 2)) # 0.3663023 (diff 18.6%)

# Marine LPI with at least 10 records in the population series
M_10r <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_10r <- M_10r[complete.cases(M_10r),] 
ggplot_lpi(M_10r, ylims=c(0, 2)) # 0.7302299 (diff 20.5%)


# change in the length of the time series (the number of years between the first and last year of the time series - duration)
# LPI with population series at least 3 years long
G_3y <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 3)
G_3y <- G_3y[complete.cases(G_3y),] 
ggplot_lpi(G_3y, ylims=c(0, 2)) # 0.3578072 (diff 3.1%)
lpis_comp <- list(G_lpi, G_3y)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 3 years"), facet=F, lpi_breaks = 0.2, alpha = 0.5)

# LPI with population series at least 5 years long
G_5y <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
G_5y <- G_5y[complete.cases(G_5y),] 
ggplot_lpi(G_5y, ylims=c(0, 2)) # 0.3097575 (diff -1.7%)
lpis_comp <- list(G_lpi, G_5y)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 5 years"), facet=F, lpi_breaks = 0.2, alpha = 0.5)

# LPI with population series at least 10 years long
G_10y <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 10)
G_10y <- G_10y[complete.cases(G_10y),] 
ggplot_lpi(G_10y, ylims=c(0, 2)) # 0.3682578 (diff 4.1%)
lpis_comp <- list(G_lpi, G_10y)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 10 years"), facet=F, lpi_breaks = 0.2, alpha = 0.5)

# Terrestrial LPI with population series at least 3 years long
T_3y <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 3)
T_3y <- T_3y[complete.cases(T_3y),] 
ggplot_lpi(T_3y, ylims=c(0, 2)) # 0.392486 (diff 2.5%)

# Freshwater LPI with population series at least 3 years long
F_3y <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 3)
F_3y <- F_3y[complete.cases(F_3y),] 
ggplot_lpi(F_3y, ylims=c(0, 2)) # 0.18187 (diff 0.1%)

# Marine LPI with population series at least 3 years long
M_3y <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 3)
M_3y <- M_3y[complete.cases(M_3y),] 
ggplot_lpi(M_3y, ylims=c(0, 2)) # 0.6417442 (diff 11.6%)

# Terrestrial LPI with population series at least 5 years long
T_5y <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
T_5y <- T_5y[complete.cases(T_5y),] 
ggplot_lpi(T_5y, ylims=c(0, 2)) # 0.3769063 (diff 0.9%)
lpis_comp <- list(T_lpi, T_5y)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 5 years"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Freshwater LPI with population series at least 5 years long
F_5y <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
F_5y <- F_5y[complete.cases(F_5y),] 
ggplot_lpi(F_5y, ylims=c(0, 2)) # 0.1212726 (diff -5.9%)
lpis_comp <- list(F_lpi, F_5y)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 5 years"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Marine LPI with population series at least 5 years long
M_5y <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
M_5y <- M_5y[complete.cases(M_5y),] 
ggplot_lpi(M_5y, ylims=c(0, 2)) # 0.6502341 (diff 12.5%)
lpis_comp <- list(M_lpi, M_5y)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", ">= 5 years"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Terrestrial LPI with population series at least 10 years long
T_10y <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 10)
T_10y <- T_10y[complete.cases(T_10y),] 
ggplot_lpi(T_10y, ylims=c(0, 2)) # 0.3972262 (diff 2.9%)

# Freshwater LPI with population series at least 10 years long
F_10y <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 10)
F_10y <- F_10y[complete.cases(F_10y),] 
ggplot_lpi(F_10y, ylims=c(0, 2)) # 0.2209794 (diff 4%)

# Marine LPI with population series at least 10 years long
M_10y <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 10)
M_10y <- M_10y[complete.cases(M_10y),] 
ggplot_lpi(M_10y, ylims=c(0, 2)) # 0.5689397 (diff 4.3%)


# effect of weighting
# LPI unweighted
G_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_now <- G_now[complete.cases(G_now),] 
ggplot_lpi(G_now, ylims=c(0, 2)) # 0.7720224 (diff 44.5%)

# LPI with population series with at least 3 records and unweighted
G_3r_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_3r_now <- G_3r_now[complete.cases(G_3r_now),] 
ggplot_lpi(G_3r_now, ylims=c(0, 2)) # 0.9415288 (diff 61.46%)

# LPI with population series with at least 5 records and unweighted
G_5r_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_5r_now <- G_5r_now[complete.cases(G_5r_now),] 
ggplot_lpi(G_5r_now, ylims=c(0, 2)) # 1.0038156 (diff 67.68%)

# LPI with population series with at least 10 records and unweighted
G_10r_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_10r_now <- G_10r_now[complete.cases(G_10r_now),] 
ggplot_lpi(G_10r_now, ylims=c(0, 2)) # 0.8200343 (diff 49.31%)

# LPI with population series at least 3 years long and unweighted
G_3y_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 3)
G_3y_now <- G_3y_now[complete.cases(G_3y_now),] 
ggplot_lpi(G_3y_now, ylims=c(0, 2)) # 0.8110557 (diff 48.4%)

# LPI with population series at least 5 years long and unweighted
G_5y_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
G_5y_now <- G_5y_now[complete.cases(G_5y_now),] 
ggplot_lpi(G_5y_now, ylims=c(0, 2)) # 0.7428260 (diff 41.6%)

# LPI with population series at least 10 years long and unweighted
G_10y_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 10)
G_10y_now <- G_10y_now[complete.cases(G_10y_now),] 
ggplot_lpi(G_10y_now, ylims=c(0, 2)) # 0.8463888 (diff 51.94%)

# Terrestrial LPI unweighted
T_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_now <- T_now[complete.cases(T_now),] 
ggplot_lpi(T_now, ylims=c(0, 2)) # 0.5164152 (diff 14.9%)

# Freshwater LPI unweighted
F_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_now <- F_now[complete.cases(F_now),] 
ggplot_lpi(F_now, ylims=c(0, 2)) # 0.6536838 (diff 47.3%)

# Marine LPI unweighted
M_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_now <- M_now[complete.cases(M_now),] 
ggplot_lpi(M_now, ylims=c(0, 2)) # 1.361132 (diff 83.5%)

# Terrestrial LPI with population series with at least 3 records and unweighted
T_3r_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_3r_now <- T_3r_now[complete.cases(T_3r_now),] 
ggplot_lpi(T_3r_now, ylims=c(0, 2)) # 0.5349277 (diff 16.7%)

# Freshwater LPI with population series with at least 3 records and unweighted
F_3r_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_3r_now <- F_3r_now[complete.cases(F_3r_now),] 
ggplot_lpi(F_3r_now, ylims=c(0, 2)) # 0.9633894 (diff 78.3%)

# Marine LPI with population series with at least 3 records and unweighted
M_3r_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_3r_now <- M_3r_now[complete.cases(M_3r_now),] 
ggplot_lpi(M_3r_now, ylims=c(0, 2)) # 1.615887  (diff 1.090)

# Terrestrial LPI with population series with at least 5 records and unweighted
T_5r_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_5r_now <- T_5r_now[complete.cases(T_5r_now),] 
ggplot_lpi(T_5r_now, ylims=c(0, 2)) # 0.6128749 (diff 24.5%)

# Freshwater LPI with population series with at least 5 records and unweighted
F_5r_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_5r_now <- F_5r_now[complete.cases(F_5r_now),] 
ggplot_lpi(F_5r_now, ylims=c(0, 2)) # 0.8906356 (diff 71%)

# Marine LPI with population series with at least 5 records and unweighted
M_5r_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_5r_now <- M_5r_now[complete.cases(M_5r_now),] 
ggplot_lpi(M_5r_now, ylims=c(0, 2)) # 2.011677 (diff 1.486)

# Terrestrial LPI with population series with at least 10 records and unweighted
T_10r_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_10r_now <- T_10r_now[complete.cases(T_10r_now),] 
ggplot_lpi(T_10r_now, ylims=c(0, 2)) # 0.6802295 (diff 31.2%)

# Freshwater LPI with population series with at least 10 records and unweighted
F_10r_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_10r_now <- F_10r_now[complete.cases(F_10r_now),] 
ggplot_lpi(F_10r_now, ylims=c(0, 2)) # 0.6237887 (diff 44.3%)

# Marine LPI with population series with at least 10 records and unweighted
M_10r_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_10r_now <- M_10r_now[complete.cases(M_10r_now),] 
ggplot_lpi(M_10r_now, ylims=c(0, 2)) # 1.680686 (diff 1.155)

# Terrestrial LPI with population series at least 3 years long and unweighted
T_3y_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 3)
T_3y_now <- T_3y_now[complete.cases(T_3y_now),] 
ggplot_lpi(T_3y_now, ylims=c(0, 2)) # 0.5201358 (diff 15.2%)

# Freshwater LPI with population series at least 3 years long and unweighted
F_3y_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 3)
F_3y_now <- F_3y_now[complete.cases(F_3y_now),] 
ggplot_lpi(F_3y_now, ylims=c(0, 2)) # 0.6717471 (diff 49.1%)

# Marine LPI with population series at least 3 years long and unweighted
M_3y_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 3)
M_3y_now <- M_3y_now[complete.cases(M_3y_now),] 
ggplot_lpi(M_3y_now, ylims=c(0, 2)) # 1.510125 (diff 98.4%)

# Terrestrial LPI with population series at least 5 years long and unweighted
T_5y_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
T_5y_now <- T_5y_now[complete.cases(T_5y_now),] 
ggplot_lpi(T_5y_now, ylims=c(0, 2)) # 0.5245724 (diff 15.7%)

# Freshwater LPI with population series at least 5 years long and unweighted
F_5y_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
F_5y_now <- F_5y_now[complete.cases(F_5y_now),] 
ggplot_lpi(F_5y_now, ylims=c(0, 2)) # 0.5142955 (diff 33.4%)

# Marine LPI with population series at least 5 years long and unweighted
M_5y_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
M_5y_now <- M_5y_now[complete.cases(M_5y_now),] 
ggplot_lpi(M_5y_now, ylims=c(0, 2)) # 1.522183 (diff 99.7%)

# Terrestrial LPI with population series at least 10 years long and unweighted
T_10y_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 10)
T_10y_now <- T_10y_now[complete.cases(T_10y_now),] 
ggplot_lpi(T_10y_now, ylims=c(0, 2)) # 0.5082316 (diff 14%)

# Freshwater LPI with population series at least 10 years long and unweighted
F_10y_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 10)
F_10y_now <- F_10y_now[complete.cases(F_10y_now),] 
ggplot_lpi(F_10y_now, ylims=c(0, 2)) # 0.9704701 (diff 79%)

# Marine LPI with population series at least 10 years long and unweighted
M_10y_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 10)
M_10y_now <- M_10y_now[complete.cases(M_10y_now),] 
ggplot_lpi(M_10y_now, ylims=c(0, 2)) # 1.413325 (diff 88.8%)

# LPI unweighted realms
G_nowB <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_nowB <- G_nowB[complete.cases(G_nowB),] 
ggplot_lpi(G_nowB, ylims=c(0, 2)) # 0.5364461 (diff 20.9%)

# Terrestrial LPI unweighted realms
T_nowB <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_nowB <- T_nowB[complete.cases(T_nowB),] 
ggplot_lpi(T_nowB, ylims=c(0, 2)) # 0.4808346 (dif 11.3%)

# Freshwater LPI unweighted realms
F_nowB <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_nowB <- F_nowB[complete.cases(F_nowB),] 
ggplot_lpi(F_nowB, ylims=c(0, 2)) # 0.3662546 (diff 18.5%)

# Marine LPI unweighted realms
M_nowB <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_nowB <- M_nowB[complete.cases(M_nowB),] 
ggplot_lpi(M_nowB, ylims=c(0, 2)) # 0.8423845 (diff 31.7%)


# effect of zeros
# LPI without zeros in the population series
G_no0 <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0 <- G_no0[complete.cases(G_no0),] 
ggplot_lpi(G_no0, ylims=c(0, 2)) # 0.5193031 (diff 19.2%)
lpis_comp <- list(G_lpi, G_no0)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", "zeros removal"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# LPI without marginal zeros in the population series
G_no0m <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0m <- G_no0m[complete.cases(G_no0m),] 
ggplot_lpi(G_no0m, ylims=c(0, 2)) # 0.5400079 (diff 21.3%)

# Terrestrial LPI without marginal zeros in the population series
T_no0m <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                  CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0m <- T_no0m[complete.cases(T_no0m),] 
ggplot_lpi(T_no0m, ylims=c(0, 2)) # 0.6688371 (diff 30.1%)

# Freshwater LPI without marginal zeros in the population series
F_no0m <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                  CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0m <- F_no0m[complete.cases(F_no0m),] 
ggplot_lpi(F_no0m, ylims=c(0, 2)) # 0.4079493 (diff 22.7%)

# Marine LPI without marginal zeros in the population series
M_no0m <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                  CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0m <- M_no0m[complete.cases(M_no0m),] 
ggplot_lpi(M_no0m, ylims=c(0, 2)) # 0.5771302 (diff 5.1%)

# LPI without marginal zeros in the population series and unweighted
G_no0m_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                  CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0m_now <- G_no0m_now[complete.cases(G_no0m_now),] 
ggplot_lpi(G_no0m_now, ylims=c(0, 2)) # 0.9608996 (diff 63.4%)

# Terrestrial LPI without marginal zeros in the population series and unweighted
T_no0m_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                  CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0m_now <- T_no0m_now[complete.cases(T_no0m_now),] 
ggplot_lpi(T_no0m_now, ylims=c(0, 2)) # 0.7531657 (diff 38.5%)

# Freshwater LPI without marginal zeros in the population series and unweighted
F_no0m_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                  CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0m_now <- F_no0m_now[complete.cases(F_no0m_now),] 
ggplot_lpi(F_no0m_now, ylims=c(0, 2)) # 0.9498450 (diff 76.9%)

# Marine LPI without marginal zeros in the population series and unweighted
M_no0m_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                  CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0m_now <- M_no0m_now[complete.cases(M_no0m_now),] 
ggplot_lpi(M_no0m_now, ylims=c(0, 2)) # 1.248684 (diff 72.3%)

# LPI without zeros in the population series with at least 3 records
G_no0_3r <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0_3r <- G_no0_3r[complete.cases(G_no0_3r),] 
ggplot_lpi(G_no0_3r, ylims=c(0, 2)) # 0.5641844 (diff 23.7%) (zeros 19.2%, 3 records 14.3%)

# LPI without zeros in the population series with at least 3 records and unweighted
G_no0_3r_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0_3r_now <- G_no0_3r_now[complete.cases(G_no0_3r_now),] 
ggplot_lpi(G_no0_3r_now, ylims=c(0, 2)) # 1.0383438 (diff 71.1%)

# LPI without zeros in the population series with at least 5 records
G_no0_5r <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0_5r <- G_no0_5r[complete.cases(G_no0_5r),] 
ggplot_lpi(G_no0_5r, ylims=c(0, 2)) # 0.6388858 (diff 31.2%) (zeros 19.2%, 5 records 14.7%)
lpis_comp <- list(G_lpi, G_no0_5r)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", "adjusted"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# LPI without zeros in the population series with at least 5 records and unweighted
G_no0_5r_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0_5r_now <- G_no0_5r_now[complete.cases(G_no0_5r_now),] 
ggplot_lpi(G_no0_5r_now, ylims=c(0, 2)) # 1.1546166 (diff 82.8%)

# LPI without zeros in the population series with at least 5 records and unweighted realms
G_no0_5r_nowB <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                        CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0_5r_nowB <- G_no0_5r_nowB[complete.cases(G_no0_5r_nowB),] 
ggplot_lpi(G_no0_5r_nowB, ylims=c(0, 2)) # 0.8319740 (diff 50.5%)

# LPI without zeros in the population series with at least 10 records
G_no0_10r <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                         CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0_10r <- G_no0_10r[complete.cases(G_no0_10r),] 
ggplot_lpi(G_no0_10r, ylims=c(0, 2)) # 0.6865022 (diff 36%)

# LPI without zeros in the population series with at least 10 records and unweighted
G_no0_10r_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                        CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0_10r_now <- G_no0_10r_now[complete.cases(G_no0_10r_now),] 
ggplot_lpi(G_no0_10r_now, ylims=c(0, 2)) # 0.9724987 (diff 64.6%)

# LPI without zeros in the population series at least 5 years long
G_no0_5y <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
G_no0_5y <- G_no0_5y[complete.cases(G_no0_5y),] 
ggplot_lpi(G_no0_5y, ylims=c(0, 2)) # 0.5521457 (diff 22.5%) (zeros 19.2%, 5 years -1.7%)

# LPI without zeros in the population series at least 5 years long and unweighted
G_no0_5y_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
G_no0_5y_now <- G_no0_5y_now[complete.cases(G_no0_5y_now),] 
ggplot_lpi(G_no0_5y_now, ylims=c(0, 2)) # 0.9612295 (diff 63.4%)

# LPI without zeros in the population series and unweighted
G_no0_now <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                        CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_no0_now <- G_no0_now[complete.cases(G_no0_now),] 
ggplot_lpi(G_no0_now, ylims=c(0, 2)) # 0.9885100 (diff 66.2%)

# Terrestrial LPI without zeros in the population series
T_no0 <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0 <- T_no0[complete.cases(T_no0),] 
ggplot_lpi(T_no0, ylims=c(0, 2)) # 0.7057608 (diff 33.8%)
lpis_comp <- list(T_lpi, T_no0)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", "zeros removal"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Freshwater LPI without zeros in the population series
F_no0 <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0 <- F_no0[complete.cases(F_no0),] 
ggplot_lpi(F_no0, ylims=c(0, 2)) # 0.373266 (diff 19.3%)
lpis_comp <- list(F_lpi, F_no0)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", "zeros removal"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Marine LPI without zeros in the population series
M_no0 <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0 <- M_no0[complete.cases(M_no0),] 
ggplot_lpi(M_no0, ylims=c(0, 2)) # 0.5316022 (diff 0%)
lpis_comp <- list(M_lpi, M_no0)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", "zeros removal"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Terrestrial LPI without zeros in the population series with at least 3 records
T_no0_3r <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0_3r <- T_no0_3r[complete.cases(T_no0_3r),] 
ggplot_lpi(T_no0_3r, ylims=c(0, 2)) # 0.7185978 (diff 35.1%)

# Terrestrial LPI without zeros in the population series with at least 3 records and unweighted
T_no0_3r_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0_3r_now <- T_no0_3r_now[complete.cases(T_no0_3r_now),] 
ggplot_lpi(T_no0_3r_now, ylims=c(0, 2)) # 0.8135285 (diff 44.6%)

# Terrestrial LPI without zeros in the population series with at least 5 records
T_no0_5r <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0_5r <- T_no0_5r[complete.cases(T_no0_5r),] 
ggplot_lpi(T_no0_5r, ylims=c(0, 2)) # 0.9646828 (diff 59.7%)
lpis_comp <- list(T_lpi, T_no0_5r)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", "adjusted"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Terrestrial LPI without zeros in the population series with at least 5 records and unweighted
T_no0_5r_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0_5r_now <- T_no0_5r_now[complete.cases(T_no0_5r_now),] 
ggplot_lpi(T_no0_5r_now, ylims=c(0, 2)) # 1.0750841 (diff 70.7%)

# Terrestrial LPI without zeros in the population series with at least 5 records and unweighted realms
T_no0_5r_nowB <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                        CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0_5r_nowB <- T_no0_5r_nowB[complete.cases(T_no0_5r_nowB),] 
ggplot_lpi(T_no0_5r_nowB, ylims=c(0, 2)) # 1.0375061 (diff 67%)

# Terrestrial LPI without zeros in the population series with at least 10 records
T_no0_10r <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0_10r <- T_no0_10r[complete.cases(T_no0_10r),] 
ggplot_lpi(T_no0_10r, ylims=c(0, 2)) # 0.9743157 (diff 60.6%)

# Terrestrial LPI without zeros in the population series with at least 10 records and unweighted
T_no0_10r_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                     CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0_10r_now <- T_no0_10r_now[complete.cases(T_no0_10r_now),] 
ggplot_lpi(T_no0_10r_now, ylims=c(0, 2)) # 1.016290 (diff 64.8%)

# Terrestrial LPI without zeros in the population series and unweighted
T_no0_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                         CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_no0_now <- T_no0_now[complete.cases(T_no0_now),] 
ggplot_lpi(T_no0_now, ylims=c(0, 2)) # 0.8203613 (diff 45.2%)

# Freshwater LPI without zeros in the population series with at least 3 records
F_no0_3r <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0_3r <- F_no0_3r[complete.cases(F_no0_3r),] 
ggplot_lpi(F_no0_3r, ylims=c(0, 2)) # 0.3814406 (diff 20.1%)

# Freshwater LPI without zeros in the population series with at least 3 records and unweighted
F_no0_3r_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0_3r_now <- F_no0_3r_now[complete.cases(F_no0_3r_now),] 
ggplot_lpi(F_no0_3r_now, ylims=c(0, 2)) # 0.8851526 (diff 70.4%)

# Freshwater LPI without zeros in the population series with at least 5 records
F_no0_5r <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0_5r <- F_no0_5r[complete.cases(F_no0_5r),] 
ggplot_lpi(F_no0_5r, ylims=c(0, 2)) # 0.4115727 (diff 23.1%)
lpis_comp <- list(F_lpi, F_no0_5r)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", "adjusted"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Freshwater LPI without zeros in the population series with at least 5 records unweighted
F_no0_5r_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0_5r_now <- F_no0_5r_now[complete.cases(F_no0_5r_now),] 
ggplot_lpi(F_no0_5r_now, ylims=c(0, 2)) # 0.9750682 (diff 79.4%)

# Freshwater LPI without zeros in the population series with at least 5 records unweighted realms
F_no0_5r_nowB <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                        CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0_5r_nowB <- F_no0_5r_nowB[complete.cases(F_no0_5r_nowB),] 
ggplot_lpi(F_no0_5r_nowB, ylims=c(0, 2)) # 0.6375149 (diff 45.7%)

# Freshwater LPI without zeros in the population series with at least 10 records
F_no0_10r <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0_10r <- F_no0_10r[complete.cases(F_no0_10r),] 
ggplot_lpi(F_no0_10r, ylims=c(0, 2)) # 0.5012885 (diff 32.1%)

# Freshwater LPI without zeros in the population series with at least 10 records and unweighted
F_no0_10r_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                     CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0_10r_now <- F_no0_10r_now[complete.cases(F_no0_10r_now),] 
ggplot_lpi(F_no0_10r_now, ylims=c(0, 2)) # 0.6880363 (diff 50.7%)

# Freshwater LPI without zeros in the population series and unweighted
F_no0_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                         CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_no0_now <- F_no0_now[complete.cases(F_no0_now),] 
ggplot_lpi(F_no0_now, ylims=c(0, 2)) # 0.9101739 (diff 72.9%)

# Marine LPI without zeros in the population series with at least 3 records
M_no0_3r <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0_3r <- M_no0_3r[complete.cases(M_no0_3r),] 
ggplot_lpi(M_no0_3r, ylims=c(0, 2)) # 0.6551646 (diff 12.9%)

# Marine LPI without zeros in the population series with at least 3 records and unweighted
M_no0_3r_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 3, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0_3r_now <- M_no0_3r_now[complete.cases(M_no0_3r_now),] 
ggplot_lpi(M_no0_3r_now, ylims=c(0, 2)) # 1.518421 (diff 99.3%)

# Marine LPI without zeros in the population series with at least 5 records
M_no0_5r <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0_5r <- M_no0_5r[complete.cases(M_no0_5r),] 
ggplot_lpi(M_no0_5r, ylims=c(0, 2)) # 0.6568083 (diff 13.1%)
lpis_comp <- list(M_lpi, M_no0_5r)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", "adjusted"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Marine LPI without zeros in the population series with at least 5 records unweighted
M_no0_5r_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0_5r_now <- M_no0_5r_now[complete.cases(M_no0_5r_now),] 
ggplot_lpi(M_no0_5r_now, ylims=c(0, 2)) # 1.579358 (diff 1.054)

# Marine LPI without zeros in the population series with at least 5 records unweighted realms
M_no0_5r_nowB <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 5, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0_5r_nowB <- M_no0_5r_nowB[complete.cases(M_no0_5r_nowB),] 
ggplot_lpi(M_no0_5r_nowB, ylims=c(0, 2)) # 0.9069103 (diff 38.1%)

# Marine LPI without zeros in the population series with at least 10 records
M_no0_10r <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0_10r <- M_no0_10r[complete.cases(M_no0_10r),] 
ggplot_lpi(M_no0_10r, ylims=c(0, 2)) # 0.6624275 (diff 13.7%)

# Marine LPI without zeros in the population series with at least 10 records and unweighted
M_no0_10r_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 10, PLOT_MAX = 2015,
                     CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0_10r_now <- M_no0_10r_now[complete.cases(M_no0_10r_now),] 
ggplot_lpi(M_no0_10r_now, ylims=c(0, 2)) # 1.543199 (diff 1.018)

# Marine LPI without zeros in the population series and unweighted
M_no0_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                         CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
M_no0_now <- M_no0_now[complete.cases(M_no0_now),] 
ggplot_lpi(M_no0_now, ylims=c(0, 2)) # 1.299488 (diff 77.4%)

# Terrestrial LPI without zeros in the population series at least 5 years long
T_no0_5y <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
T_no0_5y <- T_no0_5y[complete.cases(T_no0_5y),] 
ggplot_lpi(T_no0_5y, ylims=c(0, 2)) # 0.7035834 (diff 33.6%)

# Terrestrial LPI without zeros in the population series at least 5 years long and unweighted
T_no0_5y_now <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
T_no0_5y_now <- T_no0_5y_now[complete.cases(T_no0_5y_now),] 
ggplot_lpi(T_no0_5y_now, ylims=c(0, 2)) # 0.7784609 (diff 41.1%)

# Freshwater LPI without zeros in the population series at least 5 years long
F_no0_5y <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
F_no0_5y <- F_no0_5y[complete.cases(F_no0_5y),] 
ggplot_lpi(F_no0_5y, ylims=c(0, 2)) # 0.3470637 (diff 16.6%)

# Freshwater LPI without zeros in the population series at least 5 years long and unweighted
F_no0_5y_now <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
F_no0_5y_now <- F_no0_5y_now[complete.cases(F_no0_5y_now),] 
ggplot_lpi(F_no0_5y_now, ylims=c(0, 2)) # 0.8644576 (diff 68.4%)

# Marine LPI without zeros in the population series at least 5 years long
M_no0_5y <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
M_no0_5y <- M_no0_5y[complete.cases(M_no0_5y),] 
ggplot_lpi(M_no0_5y, ylims=c(0, 2)) # 0.6893445 (diff 16.4%)

# Marine LPI without zeros in the population series at least 5 years long and unweighted
M_no0_5y_now <- LPIMain(infile = "actual_data/Marine_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, TS_length_min = 5)
M_no0_5y_now <- M_no0_5y_now[complete.cases(M_no0_5y_now),] 
ggplot_lpi(M_no0_5y_now, ylims=c(0, 2)) # 1.333641 (diff 80.8%)


# effect of single-population representatives
# LPI without the population records of the population which represents the entire taxa in a certain realm and year
G_nos <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
G_nos <- G_nos[complete.cases(G_nos),] 
ggplot_lpi(G_nos, ylims=c(0, 2)) # 0.3148202 (diff -1.2%)

# Terrestrial LPI without single-population representatives (there is only Vipera berus)
T_nos <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_nos <- T_nos[complete.cases(T_nos),] 
ggplot_lpi(T_nos, ylims=c(0, 2)) # 0.4007251 (diff 3.3%)

# Palearctic LPI without single-population representatives (there is only Vipera berus)
PaleaT_nos <- LPIMain(infile = "actual_data/Palearctic_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
PaleaT_nos <- PaleaT_nos[complete.cases(PaleaT_nos),] 
ggplot_lpi(PaleaT_nos, ylims=c(0, 2)) # 1.720773 (diff 89.5%)
lpis_comp <- list(PaleaT, PaleaT_nos)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", "no single-population representative"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)

# Palearctic herptiles LPI without single-population representatives (there is only Vipera berus)
PaleaT_H_nos <- LPIMain(infile = "actual_data/Herpeto_Palearctic_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                     CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, REF_YEAR = 1978, min_year = 1978) # population data are from 1978
PaleaT_H_nos <- PaleaT_H_nos[complete.cases(PaleaT_H_nos),] 
ggplot_lpi(PaleaT_H_nos, ylims=c(0, 2), xlims = c(1970, 2016)) # 1.155286 (diff 1.041694)

# Nearctic freshwater mammals LPI without single-population representatives (Trichechus manatus and Castor canadensis)
NeaFW_M_nos <- LPIMain(infile = "actual_data/MammalsFW_Nearctic_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                       CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, REF_YEAR = 1979, min_year = 1979) # population data are from 1979
NeaFW_M_nos <- NeaFW_M_nos[complete.cases(NeaFW_M_nos),] 
ggplot_lpi(NeaFW_M_nos, ylims=c(0, 2), xlims = c(1970, 2016)) # 1.286474 (diff -1.425681)

# Nearctic freshwater LPI without single-population representatives (Trichechus manatus and Castor canadensis)
NeaFW_nos <- LPIMain(infile = "actual_data/NearcticFW_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                       CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
NeaFW_nos <- NeaFW_nos[complete.cases(NeaFW_nos),] 
ggplot_lpi(NeaFW_nos, ylims=c(0, 2), xlims = c(1970, 2016)) # 1.046661 (diff -1%)

# Neotropic freshwater mammals LPI without single-population representatives (Lontra longicaudis and Pteronura brasiliensis)
NeoFW_M_nos <- LPIMain(infile = "actual_data/MammalsFW_Neotropical_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                       CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, REF_YEAR = 1992, min_year = 1992) # population data are from 1992
NeoFW_M_nos <- NeoFW_M_nos[complete.cases(NeoFW_M_nos),] 
ggplot_lpi(NeoFW_M_nos, ylims=c(0, 4.1), xlims = c(1970, 2016)) # 2.290157 (diff 90.8%)

# Neotropic freshwater LPI without single-population representatives (Lontra longicaudis and Pteronura brasiliensis)
NeoFW_nos <- LPIMain(infile = "actual_data/NeotropicalFW_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                       CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
NeoFW_nos <- NeoFW_nos[complete.cases(NeoFW_nos),] 
ggplot_lpi(NeoFW_nos, ylims=c(0, 2), xlims = c(1970, 2016)) # 0.01562843 (diff 0%)

# Afrotropical freshwater herptiles LPI without single-population representatives (Crocodylus niloticus)
AfFW_H_nos <- LPIMain(infile = "actual_data/HerpetoFW_Afrotropical_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                       CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, REF_YEAR = 1975, min_year = 1975) # population data are from 1975
AfFW_H_nos <- AfFW_H_nos[complete.cases(AfFW_H_nos),] 
ggplot_lpi(AfFW_H_nos, ylims=c(0, 2), xlims = c(1970, 2016)) # 0.3385668 (diff -21%)

# Afrotropical freshwater LPI without single-population representatives (Crocodylus niloticus)
AfFW_nos <- LPIMain(infile = "actual_data/AfrotropicalFW_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                      CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
AfFW_nos <- AfFW_nos[complete.cases(AfFW_nos),] 
ggplot_lpi(AfFW_nos, ylims=c(0, 2), xlims = c(1970, 2016)) # 0.6909961 (diff -7.3%)

# Indo-Pacific freshwater fish LPI without single-population representatives (Oncorhynchus tshawytscha and Channa striata)
IndoFW_F_nos <- LPIMain(infile = "actual_data/FishFW_Indo-Pacific_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                      CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, REF_YEAR = 1985, min_year = 1985) # population data are from 1985
IndoFW_F_nos <- IndoFW_F_nos[complete.cases(IndoFW_F_nos),] 
ggplot_lpi(IndoFW_F_nos, ylims=c(0, 2), xlims = c(1970, 2016)) # 0.4028042 (diff -14.9%)

# Indo-Pacific freshwater LPI without single-population representatives (Oncorhynchus tshawytscha and Channa striata)
IndoFW_nos <- LPIMain(infile = "actual_data/Indo-PacificFW_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                        CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
IndoFW_nos <- IndoFW_nos[complete.cases(IndoFW_nos),] 
ggplot_lpi(IndoFW_nos, ylims=c(0, 2), xlims = c(1970, 2016)) # 0.3563389 (diff -43.1%)

# Freshwater LPI without 4 records (1973-1976) of Oncorhynchus tshawytscha in Indo-Pacific
F_nosO <- LPIMain(infile = "actual_data/Freshwater_all_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
F_nosO <- F_nosO[complete.cases(F_nosO),] 
ggplot_lpi(F_nosO, ylims=c(0, 2)) # 0.1565466 (diff -2.4%)

# Arctic marine mammals LPI without single-population representatives (Balaenoptera physalus and Ursus maritimus)
ArcM_M_nos <- LPIMain(infile = "actual_data/MammalsM_Arctic_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                        CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, REF_YEAR = 1977, min_year = 1977) # population data are from 1977
ArcM_M_nos <- ArcM_M_nos[complete.cases(ArcM_M_nos),] 
ggplot_lpi(ArcM_M_nos, ylims=c(0, 2), xlims = c(1970, 2016)) # 1.27241 (diff -84.7%)

# Arctic marine LPI without single-population representatives (Balaenoptera physalus and Ursus maritimus)
ArcM_nos <- LPIMain(infile = "actual_data/ArcticM_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                      CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
ArcM_nos <- ArcM_nos[complete.cases(ArcM_nos),] 
ggplot_lpi(ArcM_nos, ylims=c(0, 3.4), xlims = c(1970, 2016)) # 2.710135 (diff -4.9%)

# Palearctic LPI
PaleaT <- LPIMain(infile = "actual_data/Palearctic_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                      CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
PaleaT <- PaleaT[complete.cases(PaleaT),] 
ggplot_lpi(PaleaT, ylims=c(0, 2)) # 0.8256522

# Palearctic herptiles LPI
PaleaT_H <- LPIMain(infile = "actual_data/Herpeto_Palearctic_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                        CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, REF_YEAR = 1974, min_year = 1974) # data from 1974
PaleaT_H <- PaleaT_H[complete.cases(PaleaT_H),] 
ggplot_lpi(PaleaT_H, ylims=c(0, 2), xlims = c(1970, 2016)) # 0.1135922

# Nearctic freshwater mammals LPI
NeaFW_M <- LPIMain(infile = "actual_data/MammalsFW_Nearctic_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                       CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F) 
NeaFW_M <- NeaFW_M[complete.cases(NeaFW_M),] 
ggplot_lpi(NeaFW_M, ylims=c(0, 2), xlims = c(1970, 2016)) # 2.712155

# Nearctic freshwater LPI
NeaFW <- LPIMain(infile = "actual_data/NearcticFW_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                     CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
NeaFW <- NeaFW[complete.cases(NeaFW),] 
ggplot_lpi(NeaFW, ylims=c(0, 2), xlims = c(1970, 2016)) # 1.05688

# Neotropic freshwater mammals LPI
NeoFW_M <- LPIMain(infile = "actual_data/MammalsFW_Neotropical_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                       CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, REF_YEAR = 1990, min_year = 1990) # data from 1990
NeoFW_M <- NeoFW_M[complete.cases(NeoFW_M),] 
ggplot_lpi(NeoFW_M, ylims=c(0, 4.1), xlims = c(1970, 2016)) # 1.382414

# Neotropic freshwater LPI
NeoFW <- LPIMain(infile = "actual_data/NeotropicalFW_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                     CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
NeoFW <- NeoFW[complete.cases(NeoFW),] 
ggplot_lpi(NeoFW, ylims=c(0, 2), xlims = c(1970, 2016)) # 0.01554966

# Afrotropical freshwater herptiles LPI
AfFW_H <- LPIMain(infile = "actual_data/HerpetoFW_Afrotropical_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                      CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, REF_YEAR = 1971, min_year = 1971) # data from 1971
AfFW_H <- AfFW_H[complete.cases(AfFW_H),] 
ggplot_lpi(AfFW_H, ylims=c(0, 2), xlims = c(1970, 2016)) # 0.5483346

# Afrotropical freshwater LPI
AfFW <- LPIMain(infile = "actual_data/AfrotropicalFW_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
AfFW <- AfFW[complete.cases(AfFW),] 
ggplot_lpi(AfFW, ylims=c(0, 2), xlims = c(1970, 2016)) # 0.7636749

# Indo-Pacific freshwater fish LPI
IndoFW_F <- LPIMain(infile = "actual_data/FishFW_Indo-Pacific_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                        CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, REF_YEAR = 1973, min_year = 1973) # data from 1973
IndoFW_F <- IndoFW_F[complete.cases(IndoFW_F),] 
ggplot_lpi(IndoFW_F, ylims=c(0, 3.6), xlims = c(1970, 2016)) # 0.5521303

# Indo-Pacific freshwater LPI
IndoFW <- LPIMain(infile = "actual_data/Indo-PacificFW_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                      CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
IndoFW <- IndoFW[complete.cases(IndoFW),] 
ggplot_lpi(IndoFW, ylims=c(0, 2.5), xlims = c(1970, 2016)) # 0.7878295

# Arctic marine mammals LPI
ArcM_M <- LPIMain(infile = "actual_data/MammalsM_Arctic_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                      CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
ArcM_M <- ArcM_M[complete.cases(ArcM_M),] 
ggplot_lpi(ArcM_M, ylims=c(0, 2), xlims = c(1970, 2016)) # 2.119784

# Arctic marine LPI
ArcM <- LPIMain(infile = "actual_data/ArcticM_infile.txt", use_weightings = T, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
ArcM <- ArcM[complete.cases(ArcM),] 
ggplot_lpi(ArcM, ylims=c(0, 3.4), xlims = c(1970, 2016)) # 2.758999


# effect of the number of realms and taxa
# Terrestrial LPI with 6 realms and 4 taxa distinguished (unweighted)
T_now_64 <- LPIMain(infile = "actual_data/Terrestrial_all_infile.txt", use_weightings = F, use_weightings_B = F, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                 CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F)
T_now_64 <- T_now_64[complete.cases(T_now_64),] 
ggplot_lpi(T_now_64, ylims=c(0, 2)) # 0.4533114 (diff -6.3%)


# function for removing zero values from the data and for counting zero values
# tabulka is data.frame (rows: populations, columns: Binomial, ID, Realm, year, popvalue) for each ecosystem
# $zeros - the number of zeros
# $tabulka_no0 - data without zeros (remove_mid=T -- removed middle zeros)
remove_zeros <- function(tabulka, remove_mid=T) {
  tab2 <- NULL
  beg0 <- 0 # the number of zero values at the beginning of the time series
  end0 <- 0 # the number of zero values at the end of the time series
  mid0 <- 0 # the number of zero values in the middle of the time series
  beg <- 0 # the number of beginnings with zeros
  end <- 0 # the number of ends with zeros
  mid.beg <- 0 # the number of middle beginnings with zeros
  mid.end <- 0 # the number of middle ends with zeros (the same number as mid.beg)
  remove_mid = remove_mid # middle zeros will be removed
  IDok <- which(unique(tabulka$ID) > 1000000) # check if IDs are below this value
  if(length(IDok) > 0) {print("there is a ID value > 1mil, change it")}
  for (i in 1:length(unique(tabulka$ID))) {
    index <- unique(tabulka$ID)[i]
    tab <- tabulka[which(tabulka$ID==index),]
    if (sum(duplicated(tab$year)) > 0) {print(paste("year has more records in the population:",index))}
    max.year <- max(tab$year)
    min.year <- min(tab$year)
    step <- 1
    if (tab$popvalue[which(tab$year==max.year)] == 0) { # if there is a zero value at the end of the time series
      step <- 2
      maxpred <- sort(tab$year,decreasing=T)[step]
      while (tab$popvalue[which(tab$year==maxpred)] == 0) {
        step <- step + 1
        maxpred <- sort(tab$year,decreasing=T)[step]
      }
    } # maxpred = the first non-zero year from the end
    if (step > 2) { # if there are more than 1 zero
      maxpred <- sort(tab$year,decreasing=T)[2:(step-1)]
    } else {
      maxpred <- NULL
    }
    if (step > 1) {end <- end + 1}
    step <- 1
    if (tab$popvalue[which(tab$year==min.year)] == 0) { # if there is a zero value at the beginning of the time series
      step <- 2
      minpo <- sort(tab$year,decreasing=F)[step]
      while (tab$popvalue[which(tab$year==minpo)] == 0) {
        step <- step + 1
        minpo <- sort(tab$year,decreasing=F)[step]
      }
    } # minpo = the first non-zero year from the beginning
    if (step > 2) { # if there are more than 1 zero
      minpo <- sort(tab$year,decreasing=F)[2:(step-1)]
    } else {
      minpo <- NULL
    }
    if (step > 1) {beg <- beg + 1}
    where0 <- which(tab$popvalue==0)
    if (length(where0) > 0) {
      for (ii in where0) {
        if (tab$year[ii]==max.year | tab$year[ii]==min.year | tab$year[ii]%in%maxpred | tab$year[ii]%in%minpo) {
          if(tab$year[ii]==max.year | tab$year[ii]%in%maxpred) {end0 <- end0 + 1}
          if(tab$year[ii]==min.year | tab$year[ii]%in%minpo) {beg0 <- beg0 + 1}
          tab$popvalue[ii] <- NA
        } else {
          if(remove_mid == T){
            mid0 <- mid0 + 1
            dividing_year <- tab$year[ii]
            tab$ID[which(tab$year>dividing_year)] <- tab$ID[which(tab$year>dividing_year)] + 1000000 # create new unique ID
            tab$popvalue[ii] <- NA
          }
        }
      }
      tab3 <- tab[which(!is.na(tab$popvalue)),]
      pops <- length(unique(tab3$ID))
      mid.beg <- mid.beg + (pops - 1)
      mid.end <- mid.end + (pops - 1)
    }
    tab2 <- rbind(tab2,tab)
  }
  tab2 <- tab2[which(!is.na(tab2$popvalue)),]
  zeros <- data.frame(beg0=beg0, end0=end0, mid0=mid0, beg=beg, end=end, mid.beg=mid.beg, mid.end=mid.end)
  return(list(zeros=zeros, tabulka_no0=tab2))
}


# function for counting populations of a certain length (based on the number of records/years)
# tabulka is data.frame (rows: populations, columns: Binomial, ID, Realm, year, popvalue) for each ecosystem
# $num_pop_record - the number of populations with at least record_limit records
# $num_pop_year - the number of populations at least year_limit years long
count_pop <- function(tabulka, years_limit=1, records_limit=2) {
  rec <- 0
  year <- 0
  for (i in 1:length(unique(tabulka$ID))) {
    index <- unique(tabulka$ID)[i]
    tab <- tabulka[which(tabulka$ID==index),]
    #if(length(tab$popvalue) == 1) {print(paste("population", index, "with one record"))}
    if(length(tab$popvalue) >= records_limit) {
      rec <- rec + 1
    }
    if((max(tab$year) - min(tab$year)) >= years_limit) {
      year <- year + 1
    }
  }
  return(data.frame(num_pop_record=rec, num_pop_year=year))
}


# counting the number of populations for individual taxa and realms
# run T_lpi (see above), PopSeriesFull.txt is created
# run the commands below and then repeat the process for F_lpi and M_lpi
PopSeriesFull <- read.delim("~/actual_data/PopSeriesFull.txt") # import dataset PopSeriesFull.txt from ./actual_data
PopSeriesFull <- PopSeriesFull[,1:49] # limit data to 2016

realm <- vector(mode="character", length=nrow(PopSeriesFull)) # for a terrestrial and freshwater ecosystem
realm[grep("Afrotropical", PopSeriesFull$file)] <- "Afrotropical"
realm[grep("Nearctic", PopSeriesFull$file)] <- "Nearctic"
realm[grep("Neotropical", PopSeriesFull$file)] <- "Neotropical"
realm[grep("Palearctic", PopSeriesFull$file)] <- "Palearctic"
realm[grep("Indo-Pacific", PopSeriesFull$file)] <- "Indo-Pacific"

realm <- vector(mode="character", length=nrow(PopSeriesFull)) # for a marine ecosystem
realm[grep("Arctic", PopSeriesFull$file)] <- "Arctic"
realm[grep("ATemp", PopSeriesFull$file)] <- "AtlanticTemp"
realm[grep("ATrop", PopSeriesFull$file)] <- "AtlanticTrop"
realm[grep("PTemp", PopSeriesFull$file)] <- "PacificTemp"
realm[grep("IndoP", PopSeriesFull$file)] <- "IndoPacific"
realm[grep("STemp", PopSeriesFull$file)] <- "SouthTemp"

taxon <- vector(mode="character", length=nrow(PopSeriesFull))
taxon[grep("Mammals", PopSeriesFull$file)] <- "Mammals"
taxon[grep("Birds", PopSeriesFull$file)] <- "Birds"
taxon[grep("Herpeto", PopSeriesFull$file)] <- "Herpeto" # not for a marine ecosystem
taxon[grep("Fish", PopSeriesFull$file)] <- "Fish" # only for a freshwater and marine ecosystem
taxon[grep("Reptile", PopSeriesFull$file)] <- "Reptile" # only for a marine ecosystem

PopSeriesFullT <- cbind(realm, taxon, PopSeriesFull) # for a terrestrial ecosystem
TPalea <- PopSeriesFullT[PopSeriesFullT$realm=="Palearctic",]
TNearctic <- PopSeriesFullT[PopSeriesFullT$realm=="Nearctic",]
TNeotropical <- PopSeriesFullT[PopSeriesFullT$realm=="Neotropical",]
TAfrotropical <- PopSeriesFullT[PopSeriesFullT$realm=="Afrotropical",]
TIndo <- PopSeriesFullT[PopSeriesFullT$realm=="Indo-Pacific",]

PopSeriesFullF <- cbind(realm, taxon, PopSeriesFull) # for a freshwater ecosystem
FPalea <- PopSeriesFullF[PopSeriesFullF$realm=="Palearctic",]
FNearctic <- PopSeriesFullF[PopSeriesFullF$realm=="Nearctic",]
FNeotropical <- PopSeriesFullF[PopSeriesFullF$realm=="Neotropical",]
FAfrotropical <- PopSeriesFullF[PopSeriesFullF$realm=="Afrotropical",]
FIndo <- PopSeriesFullF[PopSeriesFullF$realm=="Indo-Pacific",]

PopSeriesFullM <- cbind(realm, taxon, PopSeriesFull) # for a marine ecosystem
MArctic <- PopSeriesFullM[PopSeriesFullM$realm=="Arctic",]
MAtlanticTemp <- PopSeriesFullM[PopSeriesFullM$realm=="AtlanticTemp",]
MAtlanticTrop <- PopSeriesFullM[PopSeriesFullM$realm=="AtlanticTrop",]
MPacificTemp <- PopSeriesFullM[PopSeriesFullM$realm=="PacificTemp",]
MIndoPacific <- PopSeriesFullM[PopSeriesFullM$realm=="IndoPacific",]
MSouthTemp <- PopSeriesFullM[PopSeriesFullM$realm=="SouthTemp",]

rm(PopSeriesFull)

subdata <- TPalea # run for each realm
subdata <- aggregate(subdata[,-c(1:4)], list(subdata$taxon), function(x) {sum(!is.na(x))})
names(subdata) <- gsub("X", "", names(subdata))

subdata1 <- subdata |> 
  pivot_longer(cols = where(is.numeric),
               names_to = "years",
               values_to = "numbers")
subdata1 <- as.data.frame(subdata1)
subdata1$years <- as.numeric(subdata1$years)
names(subdata1)[1] <- "taxon"

subdata1 %>%
  ggplot( aes(x=years, y=numbers, group=taxon, color=taxon)) +
  geom_line(linewidth=1.5, alpha=1) +
  scale_color_manual(values=c("#56B4E9", "#CC79A7", "#009E73")) +
  theme(legend.position="none") +
  theme_light() +
  labs(y = "numbers of populations") +
  scale_x_continuous(breaks=seq(from=1970, by=5, to=2015)) + 
  annotate(geom="text", x=1970, y=295, label="South Temperate", color="grey40", size=7, hjust=0) + # only for a marine ecosystem
  theme(panel.grid.minor.x=element_blank(), axis.title.x=element_blank(),
        axis.text=element_text(size=12),
        axis.title.y=element_text(hjust=0.5, margin=margin(r=7), size=14),
        axis.ticks.x = element_blank(), axis.ticks.y = element_blank(),
        axis.line = element_line(linewidth = 0.5, color="grey70"),
        plot.margin=margin(20,20,20,10),
        legend.position="none")
# saved SVG (600:480)
# c("#56B4E9", "#E69F00", "#009E73") birds, herpeto, mammals - terrestrial realms
# c("#56B4E9", "#CC79A7", "#E69F00", "#009E73") birds, fish, herpeto, mammals - freshwater realms
# c("#56B4E9", "#CC79A7", "#009E73", "#F0E442") birds, fish, mammals, reptiles - marine realms
# c("#56B4E9", "#CC79A7", "#009E73") birds, fish, mammals - Arctic, Pacific Temperate, South Temperate realm


# function for calculating the LPI with various reference years (not part of our study)
lpi_ref <- function(FROM, TO, BY, n) {
  ref_years <- seq(from=FROM, to=TO, by=BY)
  ref_name <- paste0("G_", substr(ref_years, start=3, stop=4))
  lpiXX <- as.data.frame(matrix(nrow=n, ncol=length(ref_years)))
  for (i in 1:length(ref_years)) {
    lpiX <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, CI_FLAG = F, REF_YEAR = ref_years[i], min_year = ref_years[i])
    lpiXX[,i] <- c(rep(NA, times=(ref_years[i]-1970)), lpiX)
  }
  names(lpiXX) <- ref_name
  row.names(lpiXX) <- 1970:(1970+n-1)
  return(lpiXX)
}
G_ref <- lpi_ref(FROM = 1970, TO = 2010, BY = 5, n = 47)
ggplot_lpi_ref(G_ref) # function in file ggplot_lpi.R (.../Changed)


# function for reshuffling population time series within the study period 1970-2016 (not part of our study)
reshuffle <- foreach(i=1:100) %do%
  {lpir <- LPIMain(infile = "actual_data/Global_infile.txt", use_weightings = T, use_weightings_B = T, DATA_LENGTH_MIN = 2, PLOT_MAX = 2015,
                    CAP_LAMBDAS = F, save_plots = 0, plot_lpi = 0, VERBOSE = F, reshuffle = T)
  lpir <- lpir[complete.cases(lpir),] }

reshuffle2 <- do.call(cbind, reshuffle)
reshuffle.lpi <- reshuffle2[,seq(from=1, to=ncol(reshuffle2), by=3)]
reshuffle.CIlow <- reshuffle2[,seq(from=2, to=ncol(reshuffle2), by=3)]
reshuffle.CIhigh <- reshuffle2[,seq(from=3, to=ncol(reshuffle2), by=3)]
lpir <- apply(reshuffle.lpi, 1, mean, na.rm=T)
CIlowr <- apply(reshuffle.CIlow, 1, mean, na.rm=T)
CIhighr <- apply(reshuffle.CIhigh, 1, mean, na.rm=T)
G_lpi_reshuffle <- data.frame(LPI_final=lpir, CI_low=CIlowr, CI_high=CIhighr)

lpis_comp <- list(G_lpi, G_lpi_reshuffle)
ggplot_multi_lpi(lpis_comp, xlims=c(1970, 2016), names=c("original", "reshuffled"), facet=F, lpi_breaks = 0.2, alpha = 0.5) # saved SVG (700:550)




